#ifndef __ANALOG_IIC_H
#define __ANALOG_IIC_H
#include "main.h"
#include "stdint.h"

#define CPU_FREQUENCY_MHZ  480
#define ANALOG_IIC_SCL_PIN	  	ANALOG_IIC_SCL_Pin
#define ANALOG_IIC_SCL_PORT		ANALOG_IIC_SCL_GPIO_Port
#define ANALOG_IIC_SDA_PIN			ANALOG_IIC_SDA_Pin
#define ANALOG_IIC_SDA_PORT		ANALOG_IIC_SDA_GPIO_Port

#define SDA_Dout_LOW() HAL_GPIO_WritePin(ANALOG_IIC_SDA_PORT,ANALOG_IIC_SDA_PIN,GPIO_PIN_RESET)
#define SDA_Dout_HIGH() HAL_GPIO_WritePin(ANALOG_IIC_SDA_PORT,ANALOG_IIC_SDA_PIN,GPIO_PIN_SET)
#define SDA_Data_IN() HAL_GPIO_ReadPin(ANALOG_IIC_SDA_PORT,ANALOG_IIC_SDA_PIN)
#define SCL_Dout_LOW() HAL_GPIO_WritePin(ANALOG_IIC_SCL_PORT,ANALOG_IIC_SCL_PIN,GPIO_PIN_RESET)
#define SCL_Dout_HIGH() HAL_GPIO_WritePin(ANALOG_IIC_SCL_PORT,ANALOG_IIC_SCL_PIN,GPIO_PIN_SET)
#define SCL_Data_IN() HAL_GPIO_ReadPin(ANALOG_IIC_SCL_PORT,ANALOG_IIC_SCL_PIN)
#define SDA_Write(XX) HAL_GPIO_WritePin(ANALOG_IIC_SDA_PORT,ANALOG_IIC_SDA_PIN,(XX?GPIO_PIN_SET:GPIO_PIN_RESET))

void Analog_IIC_Init(void);
void Analog_IIC_Start(void);
void Analog_IIC_Stop(void);
void Analog_IIC_Send_Byte(uint8_t txd);
uint8_t Analog_IIC_Read_Byte(uint8_t ack);
void Analog_IIC_NAck(void);
void Analog_IIC_Ack(void);
uint8_t Analog_IIC_Wait_Ack(void);
void Delay_us(uint32_t udelay);


#endif


